library(seqinr)
library(ggrepel)

#load dataframe
all_nuc = read.csv('~/data/nuc_master.csv')
cac_fast_nuc = read_csv('~/data/cac_fast_nuc.csv')
cac_slow_nuc = read_csv('~/cdata/cac_slow_nuc.csv')
all_genes = read.csv('~/data/feature_file/gene_master.csv')


#figure 3 A
#count nucleosome in different regions
all_genes$slow_fraction = 0
for (i in 1:nrow(all_genes)) {
  sl = length(which(cac_slow_nuc$chr == all_genes$chr[i] & cac_slow_nuc$peak > all_genes$start[i] & cac_slow_nuc$peak < all_genes$end[i])) #number of slow nuc
  t = length(which(all_nuc$chr == all_genes$chr[i] & all_nuc$peak > all_genes$start[i] & all_nuc$peak < all_genes$end[i])) #totla number of nuc
  all_genes$slow_fraction[i] = sl / t
}

intergene = data.frame('start'=numeric(),'end'=numeric(),'slow_fraction'=numeric())

for (i in 1:(nrow(all_genes)-1)) {
  if(all_genes$chr[i] == all_genes$chr[i+1] & all_genes$end[i] < all_genes$start[i+1]){
    s = all_genes$end[i]  #start of the intergenic region
    e = all_genes$start[i+1]  #end of the intergenic region
    sl = length(which(cac_slow_nuc$chr == all_genes$chr[i] & cac_slow_nuc$peak >s & cac_slow_nuc$peak < e ))  #number of slow nuc 
    t = length(which(all_nuc$chr == all_genes$chr[i] & all_nuc$peak >s & all_nuc$peak < e )) #total number of nuc 
    intergene[nrow(intergene)+1,] = c(s,e,sl/t)
  }
}

intergene$txn_quintile = 'Intergenic'
nuc_bind  = rbind(all_genes[,c('slow_fraction','txn_quintile')],intergene[,c('slow_fraction','txn_quintile')])

#supplemental 6
png(file = '~/data/figure/supple_slowDensity_intergenicVSgenic.png', width =5, height = 4, units = "in", res = 200, bg = "white", type = "cairo-png" )
par(mar = c(4,4,4,2), cex=1)
boxplot(nuc_bind$slow_fraction[which(nuc_bind$txn_quintile=='Intergenic')],nuc_bind$slow_fraction[which(nuc_bind$txn_quintile!='Intergenic')],
        ylab='Fraction of slow nucleosomes',outline=F, notch=T,ylim=c(0,1.3),yaxt = 'n')
axis(side = 2, at=c(0,0.2,0.4,0.6,0.8,1),labels= c(0,0.2,0.4,0.6,0.8,1))
axis(at=c(1,2),labels = c('Intergenic','Genic'),side=1)
dev.off()


#plot figure 3A
file.name <- "/data/figure/figure3/figure3A.png"
png(file = file.name, width = 4, height = 3, units = "in", res = 300, bg = "white", type = "cairo-png" )
par(mar = c(4,4,2,1), cex=0.8, cex.main=0.7) 
boxplot(slow_fraction ~txn_quintile,data = subset(nuc_bind,slow_fraction > 0),
        xlab ='Transcription level by quintiles',ylab='Fraction of slow nucleosomes',ylim=c(0,1),cex.lab = 1.2,outline=F, notch=T,
        col='lightpink3')

dev.off()


